// Digital Lighting Controller.cpp : Defines the entry point for the application.
//

#define _CRT_SECURE_NO_WARNINGS
#include "targetver.h"
#include <Windows.h>
#include <WindowsX.h>
#include <commctrl.h>
#include "Resource.h"
#include "Playback.h"
#include "WindowDrawing.h"
#include "LoadSave.h"
#include "ToolbarsMenus.h"
#include "WAVBrowse.h"
#include "Undo.h"
#include "EditSequence.h"
#include "Win32Utilities.h"
#include "CopyPaste.h"
#include "Dialogs.h"

#define MAX_LOADSTRING 100

// Global Variables:
HINSTANCE hInst;								// current instance
HCURSOR curs_sizens, curs_sizewe, curs_default, curs_ibeam;
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
HWND				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);


// Status variables
int shift_down, ctrl_down, alt_down;
bool dragging_horz_divider, dragging_vert_divider;
int divider_drag_pos;
bool selecting_range, selecting_drag;
int select_dragging_what, selecting_lights, maybe_selecting_lights, moving_light_selection;
bool horz_scroll_drag;
int horz_scroll_pos, horz_scroll_init_pos;
int autoscroll_speed;
int scroll_original_pos;
bool g_bPlayingView;

// Light variables
wchar_t light_names[32][256];
unsigned long light_colours[32] = { RGB(255, 32, 32), RGB(0, 220, 0), RGB(96, 96, 255), RGB(220, 220, 0), RGB(255, 0, 255), RGB(0, 255, 255), RGB(255, 128, 128), RGB(128, 128, 255),
									RGB(255, 32, 32), RGB(0, 220, 0), RGB(96, 96, 255), RGB(220, 220, 0), RGB(255, 0, 255), RGB(0, 255, 255), RGB(255, 128, 128), RGB(128, 128, 255),
									RGB(255, 32, 32), RGB(0, 220, 0), RGB(96, 96, 255), RGB(220, 220, 0), RGB(255, 0, 255), RGB(0, 255, 255), RGB(255, 128, 128), RGB(128, 128, 255),
									RGB(255, 32, 32), RGB(0, 220, 0), RGB(96, 96, 255), RGB(220, 220, 0), RGB(255, 0, 255), RGB(0, 255, 255), RGB(255, 128, 128), RGB(128, 128, 255) };


HWND hDialog, hDropdown;
HACCEL hAccelTable;
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	// TODO: Place code here.
	MSG msg;

	for( int i = 0; i < 32; ++i ) {
		wsprintf(light_names[i], L"Light %d", i+1);
	}

	horiz_div_pos = LoadDwordFromRegistry(L"horiz_div_pos", horiz_div_pos);
	rcWAV.left = rcSeq.left = LoadDwordFromRegistry(L"vert_div_pos", rcWAV.left);

	curs_sizens = LoadCursor(hInst, IDC_SIZENS);
	curs_sizewe = LoadCursor(hInst, IDC_SIZEWE);
	curs_default = LoadCursor(hInst, IDC_ARROW);
	curs_ibeam = LoadCursor(hInst, IDC_IBEAM);

	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_DIGITALLIGHTINGCONTROLLER, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	HWND hWnd = InitInstance (hInstance, nCmdShow);
	if( !hWnd ) {
		return FALSE;
	}
	init_playback(hWnd);

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_DIGITALLIGHTINGCONTROLLER));

	if( strlen(lpCmdLine) > 0 ) {
		wchar_t buf[_MAX_PATH];
		if( lpCmdLine[0] == '"' && lpCmdLine[strlen(lpCmdLine)-1] == '"' ) {
			wsprintf(buf, L"%S", lpCmdLine+1);
			buf[strlen(lpCmdLine)-2] = L'\0';
		} else {
			wsprintf(buf, L"%S", lpCmdLine);
		}
		DoOpenSequence(hWnd, buf, false, -1);
	}

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if ((!IsWindow(hDialog) || !IsDialogMessage(hDialog, &msg)) && (!IsWindow(hDropdown) || !IsDialogMessage(hDropdown, &msg)) &&
			(!IsWindow(hLights) || !IsDialogMessage(hLights, &msg)) && !TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}


ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_DIGITALLIGHTINGCONTROLLER));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_DIGITALLIGHTINGCONTROLLER);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_DIGITALLIGHTINGCONTROLLER));

	return RegisterClassEx(&wcex);
}

HWND InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;

	hInst = hInstance; // Store instance handle in our global variable

	INITCOMMONCONTROLSEX InitCtrlEx;

	InitCtrlEx.dwSize = sizeof(INITCOMMONCONTROLSEX);
	InitCtrlEx.dwICC  = ICC_BAR_CLASSES|ICC_UPDOWN_CLASS;
	InitCommonControlsEx(&InitCtrlEx);

	hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW | WS_HSCROLL,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

	if (!hWnd) {
		return hWnd;
	}

	CreateToolbar(hWnd, hInst);
	LoadSettings(hWnd, hInst);
	UpdateDisabledState(hWnd);
	UpdateWindowTitle(hWnd);
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	UpdateRecentFilesMenu(hWnd, hInst);
	UpdateSelectionStorageMenu(hWnd, hInst);
	UpdateCopyBufferStorageMenu(hWnd, hInst);
	UpdatePasteSpecialMenu(hWnd, hInst);

	return hWnd;
}

void UpdateCursor(HWND hWnd, int x, int y) {
	HCURSOR cursor;
	if( wav_len == 0 || y < rcWAV.top ) {
		cursor = curs_default;
	} else {
		if( select_dragging_what || selecting_range || dragging_vert_divider || (x >= rcWAV.left - 4 && x <= rcWAV.left + 4) ) {
			cursor = curs_sizewe;
		} else if( moving_light_selection || dragging_horz_divider ) {
			cursor = curs_sizens;
		} else if( y < rcWAV.bottom - 4 ) {
			if( x < rcWAV.left ) {
				cursor = curs_default;
			} else {
			CheckMoveSelection:
				cursor = curs_ibeam;
				if( selection_start != -1 && !selecting_range && (!hDialog || CanChangeSelection(hDialog)) ) {
					SCROLLINFO si;
					si.cbSize = sizeof (si);
					si.fMask  = SIF_ALL;
					GetScrollInfo (hWnd, SB_HORZ, &si);
					int select_x1 = rcWAV.left + (selection_start >> zoom) - si.nPos;
					int select_x2 = rcWAV.left + (selection_finish >> zoom) - si.nPos;
					if( (x >= select_x1-4 && x <= select_x1+4) || (x >= select_x2-4 && x <= select_x2+4) )
						cursor = curs_sizewe;
				}
			}
		} else if( x > rcWAV.left + 4 && y > rcWAV.bottom + 4 && y < rcSeq.bottom && NumEnabledLights ) {
			bool bLastSel = false;
			cursor = curs_ibeam;
			int index = 0;
			SCROLLINFO si;
			si.cbSize = sizeof (si);
			si.fMask  = SIF_ALL;
			GetScrollInfo (hWnd, SB_HORZ, &si);
			int select_x1 = rcWAV.left + (selection_start >> zoom) - si.nPos;
			int select_x2 = rcWAV.left + (selection_finish >> zoom) - si.nPos;
			for( int i = 0; i < 32; ++i ) {
				if( !(EnabledLights&(1<<i)) )
					continue;
				int top    = rcSeq.top +  index    * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
				int bottom = rcSeq.top + (index+1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
				++index;
				bool bThisSel = (selected_lights&(1<<i)) != 0;
				bool bNextSel = i < 31 && (selected_lights&(1<<(i+1))) != 0;
				if( x >= select_x1 && x <= select_x2 &&
					(((bThisSel && !bLastSel && y >= top-4 && y <= top+4) ||
					  (bThisSel && !bNextSel && y >= bottom-4 && y <= bottom+4)) && (!hDialog || CanChangeSelection(hDialog))) ) {
					cursor = curs_sizens;
					break;
				}
				bLastSel = bThisSel;
				if( y < bottom && (!hDialog || CanChangeSelection(hDialog)) ) {
					if( selected_lights&(1<<i) )
						goto CheckMoveSelection;
					if( y < bottom-4 )
						break;
				}
			}
		} else if( y > rcWAV.bottom + 4 ) {
			cursor = curs_default;
		} else {
			cursor = curs_sizens;
		}
	}

	SetCursor(cursor);
}

void Play(HWND hWnd, int start_sample, int finish_sample, bool bPlayingView = false) {
	if( finish_sample > wav_len )
		finish_sample = wav_len;
	if( wav_len && start_sample < wav_len && finish_sample > start_sample ) {
		if( !start_playback((short*)(wav_content ? wav_content + start_sample : wav_content), finish_sample - start_sample, wav_sample_rate, 2, start_sample) ) {
			MessageBox(hWnd, L"Playback failed - please check that your sound card is set up correctly and you have DirectX 8 or later installed.", L"WAV playback failure", MB_OK|MB_ICONEXCLAMATION);
		} else {
			if( sequence_loaded )
				InitLightbar();
			g_bPlayingView = bPlayingView;
			SetTimer(hWnd, 2, 25, 0);
			InvalidateStatus(hWnd);
			DelayedUpdateDisabledState(hWnd);
		}
	}
}

int set_brightness_to = 50;
INT_PTR CALLBACK BrightnessDropdownDialogProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
		{
			HWND hTrackbar = GetSubWindow(hWnd, IDC_BRIGHTNESSSLIDER);
			HWND hEdit = GetSubWindow(hWnd, IDC_BRIGHTNESSEDIT);
			wchar_t buf[32];
			wsprintf(buf, L"%d", set_brightness_to);
			SetWindowText(hEdit, buf);
			SendMessage(hTrackbar, TBM_SETRANGE, FALSE, MAKELPARAM(0, 100));
			SendMessage(hTrackbar, TBM_SETTICFREQ, 10, 0);
			SendMessage(hTrackbar, TBM_SETPAGESIZE, 0, 10);
			SendMessage(hTrackbar, TBM_SETPOS, true, 100-set_brightness_to);
			break;
		}
	case WM_VSCROLL:
		{
			HWND hTrackbar = GetSubWindow(hWnd, IDC_BRIGHTNESSSLIDER);
			HWND hEdit = GetSubWindow(hWnd, IDC_BRIGHTNESSEDIT);
			int pos = SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
			wchar_t buf[32];
			wsprintf(buf, L"%d", 100-pos);
			SetWindowText(hEdit, buf);
		}
		break;
	case WM_COMMAND:
		if( LOWORD(wParam) == IDC_BRIGHTNESSEDIT && HIWORD(wParam) == EN_CHANGE ) {
			HWND hTrackbar = GetSubWindow(hWnd, IDC_BRIGHTNESSSLIDER);
			HWND hEdit = GetSubWindow(hWnd, IDC_BRIGHTNESSEDIT);

			wchar_t buf[32];
			if( GetWindowText(hEdit, buf, sizeof(buf)/sizeof(wchar_t)) ) {
				wchar_t* end;
				long pos = wcstol(buf, &end, 10);
				if( *end == L'\0' && pos >= 0 && pos <= 100 ) {
					SendMessage(hTrackbar, TBM_SETPOS, true, 100-pos);
				} else {
					pos = SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
					wsprintf(buf, L"%d", 100-pos);
					SetWindowText(hEdit, buf);
				}
			}
			return TRUE;
		}
		break;
	case WM_ACTIVATE:
		if( !wParam && hDropdown ) {
			HWND hTrackbar = GetSubWindow(hWnd, IDC_BRIGHTNESSSLIDER);
			set_brightness_to = 100-SendMessage(hTrackbar, TBM_GETPOS, 0, 0);
			SaveDwordToRegistry(L"Light Brightness", set_brightness_to);
			hDropdown = (HWND)NULL;
			DestroyWindow(hWnd);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		hDropdown = (HWND)NULL;
		break;
	}
	return FALSE;
}


int last_mouse_move_lparam;
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	SCROLLINFO si;
	int xPos, old_zoom, temp;

	switch (message)
	{
	case WM_CREATE:
		SetupMenus(hWnd, hInst);
		set_brightness_to = LoadDwordFromRegistry(L"Light Brightness", 50);
		SetTimer(hWnd, 3, 1000, 0);
		break;
	case WM_KEYDOWN:
		if( wParam == VK_SHIFT ) {
			shift_down |= 1;
		} else if( wParam == VK_LSHIFT ) {
			shift_down |= 2;
		} else if( wParam == VK_RSHIFT ) {
			shift_down |= 4;
		} else if( wParam == VK_CONTROL ) {
			ctrl_down |= 1;
		} else if( wParam == VK_MENU ) {
			alt_down |= 1;
		} else if( wParam == VK_LEFT || wParam == VK_RIGHT ) {
			int amount = wParam == VK_LEFT ? -1 : 1;
			amount <<= zoom;
			if( abs(amount) < (wav_sample_rate+999)/1000 ) {
				if( amount > 0 )
					amount =  (int)(wav_sample_rate+999)/1000;
				else
					amount = -(int)(wav_sample_rate+999)/1000;
			}
			if( shift_down )
				amount *= 10;
			if( ctrl_down )
				HorizScrollWindowBy(hWnd, amount>>zoom);
			else
				MoveSelection(hWnd, amount);
		} else if( wParam == VK_UP || wParam == VK_DOWN ) {
			MoveLightSelection(hWnd, wParam == VK_UP ? -1 : 1, shift_down != 0);
		} else if( wParam == VK_ESCAPE ) {
			SetSelection(hWnd, -1, -1);
			SendMessage(hWnd, WM_LBUTTONUP, 0, 0);
		} else if( ctrl_down && !alt_down && (wParam >= 'A' && wParam <= 'Z') ) {
			char shortcut = shift_down ? (char)wParam : tolower((char)wParam);
			ToolbarEntry* pEntry = FindToolbarEntry(shortcut, true);
			if( pEntry )
				SendMessage(hWnd, WM_COMMAND, pEntry->cmd, 0);
		} else {
			ToolbarEntry* pEntry = FindToolbarEntryByVKey(wParam, true);
			if( !pEntry && !(wParam >= 'A' && wParam <= 'Z') )
				pEntry = FindToolbarEntry((char)wParam, true);
			if( pEntry ) {
				SendMessage(hWnd, WM_COMMAND, pEntry->cmd, 0);
			} else if( wParam >= '1' && wParam <= '9' ) {
				if( ctrl_down && !alt_down )
					if( shift_down )
						SendMessage(hWnd, WM_COMMAND, IDM_LOADCOPYBUFFER1+(wParam-'1')*10, 0);
					else
						SendMessage(hWnd, WM_COMMAND, IDM_SAVECOPYBUFFER1+(wParam-'1')*10, 0);
				else if( ctrl_down && alt_down )
					if( shift_down )
						SendMessage(hWnd, WM_COMMAND, IDM_LOADSELECTION1+(wParam-'1')*10, 0);
					else
						SendMessage(hWnd, WM_COMMAND, IDM_SAVESELECTION1+(wParam-'1')*10, 0);
			}
		}
		break;
	case WM_KEYUP:
		if( wParam == VK_SHIFT ) {
			shift_down &= ~1;
		} else if( wParam == VK_LSHIFT ) {
			shift_down &= ~2;
		} else if( wParam == VK_RSHIFT ) {
			shift_down &= ~4;
		} else if( wParam == VK_CONTROL ) {
			ctrl_down &= ~1;
		} else if( wParam == VK_MENU ) {
			alt_down &= ~1;
		}
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);

		if( wmId >= 10000 && wmId < 10010 ) {
			if( !OpenRecentFile(hWnd, wmId) )
				MessageBox(hWnd, L"Opening that recent file failed. Please check that it still exists, is not corrupt and that you have permission to read it.", L"Sequence file read error", MB_OK|MB_ICONEXCLAMATION);
		} else if( wmId >= IDM_SAVESELECTION1 && wmId <= IDM_CLEARSELECTION9 ) {
			int location = (wmId - 210)/10;
			if( wmId%10 == 1 ) {
				if( selection_start == -1 ) {
					MessageBox(hWnd, L"There is currently no selection to save.", L"Can't save empty selection", MB_OK|MB_ICONEXCLAMATION);
				} else {
					selection_storage[location].start = selection_start;
					selection_storage[location].finish = selection_finish;
					selection_storage[location].current_light = current_light;
					selection_storage[location].selected_lights = selected_lights;
					UpdateSelectionStorageMenu(hWnd);
				}
			} else if( wmId%10 == 2 ) {
				if( selection_storage[location].start == -1 ) {
					MessageBox(hWnd, L"The selection storage location you are trying to load is empty.", L"Can't load empty selection", MB_OK|MB_ICONEXCLAMATION);
				} else {
					SetSelection(hWnd, selection_storage[location].start, selection_storage[location].finish);
					SetLightSelection(hWnd, selection_storage[location].selected_lights, selection_storage[location].current_light);
				}
			} else {
				selection_storage[location].start = -1;
				selection_storage[location].finish = -1;
				UpdateSelectionStorageMenu(hWnd);
			}
		} else if( wmId >= IDM_SAVECOPYBUFFER1 && wmId <= IDM_CLEARCOPYBUFFER9 ) {
			int location = (wmId - 310)/10;
			if( wmId%10 == 1 ) {
				if( CanPaste(NULL) ) {
					SaveToCopyBufferStorage(hWnd, location);
					UpdateCopyBufferStorageMenu(hWnd);
				} else {
					MessageBox(hWnd, L"The copy buffer is currently empty. If you want to save the current selection, please copy it into the buffer first.", L"Copy buffer empty", MB_OK|MB_ICONEXCLAMATION);
				}
			} else if( wmId%10 == 2 ) {
				if( !IsCopyBufferOccupied(location) ) {
					MessageBox(hWnd, L"The copy buffer storage location you are trying to load is empty.", L"Can't load empty copy buffer", MB_OK|MB_ICONEXCLAMATION);
				} else {
					LoadFromCopyBufferStorage(hWnd, location);
				}
			} else {
				EmptyCopyBufferStorage(hWnd, location);
				UpdateCopyBufferStorageMenu(hWnd);
			}
		} else switch (wmId) {
		case IDM_NEWFILE:
			OpenSequence(hWnd, hInst, true);
			break;
		case IDM_OPENFILE:
			OpenSequence(hWnd, hInst, false);
			break;
		case IDM_CLOSEFILE:
			CloseSequence(hWnd);
			break;
		case IDM_SAVEFILE:
			if( sequence_loaded ) {
				if( UndoIsDirty() && !SaveSequence(hWnd) ) {
					MessageBox(hWnd, L"Saving the sequence file failed. Please check that you have permission to write files into that folder and that you are not out of disk space.", L"Sequence file save error", MB_OK|MB_ICONEXCLAMATION);
				} else {
					UndoSetClean();
				}
			} else {
				MessageBox(hWnd, L"There is no sequence to save yet. Please open a WAV file first.", L"Sequence file save error", MB_OK|MB_ICONEXCLAMATION);
			}
			break;
		case IDM_SAVEFILEAS:
		case IDM_SAVECOPYAS:
			if( sequence_loaded ) {
				SaveSequenceAs(hWnd, wmId == IDM_SAVECOPYAS);
			} else {
				MessageBox(hWnd, L"There is no sequence to save yet. Please open a WAV file first.", L"Sequence file save error", MB_OK|MB_ICONEXCLAMATION);
			}
			break;
		case IDM_REVERT:
			if( sequence_loaded ) {
				if( UndoIsDirty() ) {
					if( MessageBox(hWnd, L"Are you sure that you want to discard all the changes you have made since you last saved/opened this sequence?", L"Confirm file reversion", MB_YESNO|MB_ICONEXCLAMATION) == IDYES ) {
						if( !RevertSequence(hWnd) ) {
							MessageBox(hWnd, L"The file revert failed. Check that the original file is still present.", L"Revert failed", MB_OK|MB_ICONEXCLAMATION);
						}
					}
				} else {
					MessageBox(hWnd, L"There are no changes to revert.", L"Nothing to revert", MB_OK|MB_ICONINFORMATION);
				}
			} else {
				MessageBox(hWnd, L"There is no sequence open to revert.", L"Nothing to revert", MB_OK|MB_ICONEXCLAMATION);
			}
			break;
		case IDM_PUBLISH:
			if( sequence_loaded ) {
				PublishSequence(hWnd, hInst);
			} else {
				MessageBox(hWnd, L"There is currently no sequence open to publish", L"No sequence to publish", MB_ICONEXCLAMATION|MB_OK);
			}
			break;
		case IDM_ZOOMIN:
		case IDM_ZOOMOUT:
			old_zoom = zoom;

			if( wmId == IDM_ZOOMIN ) {
				if( zoom != 0 )
					--zoom;
			} else {
				if( !(zoom == wav_mipmap_levels-1 || (wav_len>>zoom) < (rcWAV.right-rcWAV.left)) )
					++zoom;
			}
			if( old_zoom != zoom ) {
				if( playback_pos != -1 ) {
					si.cbSize = sizeof (si);
					si.fMask  = SIF_ALL;
					GetScrollInfo (hWnd, SB_HORZ, &si);
					SetScrollExtent(hWnd, old_zoom, rcWAV.left + (playback_pos>>old_zoom) - (int)si.nPos);
					if( selecting_range || select_dragging_what )
						SendMessage(hWnd, WM_MOUSEMOVE, 0, last_mouse_move_lparam);
				} else {
					SetScrollExtent(hWnd, old_zoom, -1);
					if( selecting_range || select_dragging_what )
						SendMessage(hWnd, WM_MOUSEMOVE, 0, last_mouse_move_lparam);
				}
				RECT rcRedraw = rcWAV;
				rcRedraw.bottom = rcSeq.bottom;
				InvalidateRect(hWnd, &rcRedraw, false);
				UpdateDisabledState(hWnd);
			}
			break;
		case IDM_ZOOMFITSELECTION:
			if( selection_start != -1 && selection_start != selection_finish ) {
				int target_zoom = 0;
				while( ((selection_finish - selection_start) >> target_zoom) > rcWAV.right - rcWAV.left ) {
					if( target_zoom == wav_mipmap_levels-1 || (wav_len>>target_zoom) < (rcWAV.right-rcWAV.left) )
						break;
					++target_zoom;
				}
				if( target_zoom != zoom ) {
					old_zoom = zoom;
					zoom = target_zoom;
					SetScrollExtent(hWnd, old_zoom, -1);
					if( selecting_range || select_dragging_what )
						SendMessage(hWnd, WM_MOUSEMOVE, 0, last_mouse_move_lparam);

					si.cbSize = sizeof (si);
					si.fMask  = SIF_ALL;
					GetScrollInfo (hWnd, SB_HORZ, &si);
					int scroll_pos = (selection_start >> zoom) - (rcWAV.right - rcWAV.left - ((selection_finish - selection_start) >> zoom)) / 2;
					if( scroll_pos < 0 )
						scroll_pos = 0;
					else if( scroll_pos > (wav_len>>zoom) - (int)(si.nPage-1) )
						scroll_pos = (wav_len>>zoom) - (int)(si.nPage-1);
					si.nPos = scroll_pos;
					si.fMask = SIF_POS;
					SetScrollInfo (hWnd, SB_HORZ, &si, true);

					RECT rcRedraw = rcWAV;
					rcRedraw.bottom = rcSeq.bottom;
					InvalidateRect(hWnd, &rcRedraw, false);
					UpdateDisabledState(hWnd);
				} else {
					si.cbSize = sizeof (si);
					si.fMask  = SIF_ALL;
					GetScrollInfo (hWnd, SB_HORZ, &si);

					int scroll_pos = (selection_start >> zoom) - (rcWAV.right - rcWAV.left - ((selection_finish - selection_start) >> zoom)) / 2;
					if( scroll_pos < 0 )
						scroll_pos = 0;
					else if( scroll_pos > (wav_len>>zoom) - (int)(si.nPage-1) )
						scroll_pos = (wav_len>>zoom) - (int)(si.nPage-1);

					HorizScrollWindowBy(hWnd, scroll_pos - (int)si.nPos);
				}
				break;
			}
		case IDM_ZOOMFITALL:
			{
				old_zoom = zoom;
				while( !(zoom == wav_mipmap_levels-1 || (wav_len>>zoom) < (rcWAV.right-rcWAV.left)) )
					++zoom;
				if( old_zoom != zoom ) {
					SetScrollExtent(hWnd, old_zoom, -1);
					if( selecting_range || select_dragging_what )
						SendMessage(hWnd, WM_MOUSEMOVE, 0, last_mouse_move_lparam);
					RECT rcRedraw = rcWAV;
					rcRedraw.bottom = rcSeq.bottom;
					InvalidateRect(hWnd, &rcRedraw, false);
					UpdateDisabledState(hWnd);
				}
				break;
			}
		case IDM_SELECTALL:
			SetSelection(hWnd, 0, wav_len);
			break;
		case IDM_SELECTNONE:
			SetSelection(hWnd, -1, -1);
			break;
		case IDM_SELECTALLLIGHTS:
			{
				int i = 0;
				while( !(EnabledLights&(1<<i)) && i < 32)
					++i;
				if( i == 32 )
					i = 0;
				SetLightSelection(hWnd, EnabledLights, i);
				break;
			}
		case IDM_SELECTNOLIGHTS:
			SetLightSelection(hWnd, 0, 0);
			break;
		case IDM_SELECTVIEW:
			{
				si.cbSize = sizeof (si);
				si.fMask  = SIF_ALL;
				GetScrollInfo (hWnd, SB_HORZ, &si);
				SetSelection(hWnd, si.nPos << zoom, (si.nPos + rcWAV.right - rcWAV.left) << zoom);
				break;
			}
		case IDM_SELECTPLAYBACKREGION:
			SetSelection(hWnd, playback_region_start, playback_region_finish);
			break;
		case IDM_COPY:
			Copy(hWnd);
			break;
		case IDM_CUT:
			UndoBegin();
			Copy(hWnd);
			SetSelectedLightBrightness(hWnd, 0);
			UndoEnd(hWnd);
			break;
		case IDM_PASTE:
			Paste(hWnd);
			break;
		case IDM_PASTE_MERGE:
			PasteMerge(hWnd);
			break;
		case IDM_PASTE_STRETCH:
			PasteStretch(hWnd);
			break;
		case IDM_PASTE_MERGE_STRETCH:
			PasteMergeStretch(hWnd);
			break;
		case IDM_PASTE_MIX:
			PasteMix(hWnd);
			break;
		case IDM_PASTE_MIX_STRETCH:
			PasteMixStretch(hWnd);
			break;
		case IDM_UNDO:
			Undo(hWnd);
			break;
		case IDM_REDO:
			Redo(hWnd);
			break;
		case IDM_PLAYFILE:
			Play(hWnd, 0, wav_len);
			break;
		case IDM_PLAYSELECTION:
			if( selection_start != -1 )
				Play(hWnd, selection_start, selection_finish == selection_start ? wav_len : selection_finish);
			break;
		case IDM_PLAYVIEW:
			{
				si.cbSize = sizeof (si);
				si.fMask  = SIF_ALL;
				GetScrollInfo (hWnd, SB_HORZ, &si);
				Play(hWnd, si.nPos<<zoom, (si.nPos + rcWAV.right - rcWAV.left)<<zoom, true);
				break;
			}
		case IDM_SETPLAYBACKREGION:
			SetPlaybackRegion(hWnd, selection_start, selection_finish);
			break;
		case IDM_PLAYREGION:
			if( playback_region_start != -1 )
				Play(hWnd, playback_region_start, playback_region_finish == playback_region_start ? wav_len : playback_region_finish);
			break;
		case IDM_PAUSE:
			pause_resume_playback();
			InvalidateStatus(hWnd);
			break;
		case IDM_STOP:
			stop_playback();
			InvalidateStatus(hWnd);
			DelayedUpdateDisabledState(hWnd);
			break;
		case IDM_LOOPPLAYBACK:
			ToggleLoopPlayback(hWnd);
			break;
		case IDM_FOLLOWPLAYBACKPOS:
			ToggleFollowPlaybackPos(hWnd);
			break;
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_EXIT:
			CloseSequence(hWnd);
			if( !sequence_loaded )
				DestroyWindow(hWnd);
			break;
		case IDM_CHANGELENGTH:
			{
				if( !sequence_loaded ) {
					MessageBox(hWnd, L"There is no sequence currently loaded", L"No Sequence Loaded", MB_ICONEXCLAMATION|MB_OK);
				} else if( wav_content ) {
					MessageBox(hWnd, L"You can only change the length of standalone sequences, not WAV file sequences.", L"Not a Standalone Sequence", MB_ICONEXCLAMATION|MB_OK);
				} else {
					int length_ms = (int)((wav_len + ((wav_sample_rate+999) / 1000 - 1)) * 1000LL / wav_sample_rate);
					int new_length_ms = length_ms;
					if( ChangeLengthDialog(hWnd, hInst, &new_length_ms) && new_length_ms > 0 ) {
						if( new_length_ms >= length_ms || MessageBox(hWnd, L"WARNING: You are setting the length of this sequence to a shorter time than it currently is. This will involve removing any sequence data past the new end. Do you want to continue?", L"Sequence Truncation Warning", MB_ICONEXCLAMATION|MB_YESNO) == IDYES )
							SetSequenceLength(hWnd, new_length_ms);
					}
				}
				break;
			}
		case IDM_SETTINGS:
			OpenSettingsDialog(hWnd, hInst, &hDialog);
			break;
		case IDM_CANCELLIGHTACTIONS:
			SetSelectedLightBrightness(hWnd, SETBRIGHTNESS_CANCELACTIONS);
			break;
		case IDM_LIGHTSON:
			SetSelectedLightBrightness(hWnd, 255);
			break;
		case IDM_LIGHTSOFF:
			SetSelectedLightBrightness(hWnd, 0);
			break;
		case IDM_SETBRIGHT:
			SetSelectedLightBrightness(hWnd, set_brightness_to*255/100);
			break;
		case IDM_RAMPINTERPOLATE:
			SetSelectedLightBrightness(hWnd, SETBRIGHTNESS_INTERPOLATEDRAMP);
			break;
		case IDM_RAMPUP:
			SetSelectedLightBrightness(hWnd, SETBRIGHTNESS_RAMPUP);
			break;
		case IDM_RAMPDOWN:
			SetSelectedLightBrightness(hWnd, SETBRIGHTNESS_RAMPDOWN);
			break;
		case IDM_CASCADE:
			if( lParam ) {
				DoCascade(hWnd, hInst);
			} else {
				OpenCascadeDialog(hWnd, hInst, &hDialog);
			}
			break;
		case IDM_CUSTOM_RAMP:
			if( lParam ) {
				DoCustomRamp(hWnd, hInst);
			} else {
				OpenCustomRampDialog(hWnd, hInst, &hDialog);
			}
			break;
		case IDM_BEATDETECTION:
			if( lParam ) {
				DoBeatDetection(hWnd, hInst);
			} else {
				OpenBeatDetectionDialog(hWnd, hInst, &hDialog);
			}
			break;
		case IDM_SPECTRUMANALYSIS:
			if( lParam ) {
				DoSpectrumAnalysis(hWnd, hInst);
			} else {
				OpenSpectrumAnalysisDialog(hWnd, hInst, &hDialog);
			}
			break;
		case IDM_AUTOMATICSEQUENCING:
			OpenAutomaticSequencingDialog(hWnd, hInst, &hDialog);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_SIZE:
		{
			RECT rcClient;

			SetScrollExtent(hWnd, zoom, -1);
			GetClientRect(hWnd, &rcClient);
			rcWAV.right = rcClient.right;
			rcSeq.right = rcClient.right;
			rcLightBar = rcClient;
			rcLightBar.top = rcLightBar.bottom - 32;
			rcSeq.bottom = rcLightBar.top;

			RECT rcToolbar;
			GetWindowRect(hToolbar, &rcToolbar);
			MoveWindow(hToolbar, rcToolbar.left, rcToolbar.top, rcClient.right-rcClient.left, rcToolbar.bottom-rcToolbar.top, true);
			UpdateLightBarTooltips(hWnd, hInst, light_names);
			return 0;
		}
    case WM_HSCROLL:
        // Get all the vertial scroll bar information.
        si.cbSize = sizeof (si);
        si.fMask  = SIF_ALL;

        // Save the position for comparison later on.
        GetScrollInfo (hWnd, SB_HORZ, &si);
        xPos = si.nPos;
        switch (LOWORD (wParam))
        {
        // User clicked the left arrow.
        case SB_LINELEFT: 
            si.nPos -= 1;
            break;
              
        // User clicked the right arrow.
        case SB_LINERIGHT: 
            si.nPos += 1;
            break;
              
        // User clicked the scroll bar shaft left of the scroll box.
        case SB_PAGELEFT:
            si.nPos -= si.nPage;
            break;
              
        // User clicked the scroll bar shaft right of the scroll box.
        case SB_PAGERIGHT:
            si.nPos += si.nPage;
            break;
              
        // User dragged the scroll box.
        case SB_THUMBTRACK: 
            si.nPos = si.nTrackPos;
            break;
              
        default :
            break;
        }

        // Set the position and then retrieve it.  Due to adjustments
        // by Windows it may not be the same as the value set.
        si.fMask = SIF_POS;
        SetScrollInfo (hWnd, SB_HORZ, &si, TRUE);
        GetScrollInfo (hWnd, SB_HORZ, &si);
         
        // If the position has changed, scroll the window.
        if (si.nPos != xPos)
        {
			RECT rcScroll = rcWAV;
			rcScroll.bottom = rcSeq.bottom;
            ScrollWindow(hWnd, (xPos - si.nPos), 0, &rcScroll, &rcScroll);
        }

		scroll_follows_playback = 0;
		SetTimer(hWnd, 4, 250, NULL);
		return 0;
	case WM_MOUSEWHEEL:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			old_zoom = zoom;
			temp = GET_WHEEL_DELTA_WPARAM(wParam);
			while( temp >= 120 ) {
				if( zoom == 0 )
					break;
				--zoom;
				temp -= 120;
			}
			while( temp <= -120 ) {
				if( zoom == wav_mipmap_levels-1 || (wav_len>>zoom) < (rcWAV.right-rcWAV.left) )
					break;
				++zoom;
				temp += 120;
			}
			if( old_zoom != zoom ) {
				POINT ptTemp = { x, y };
				ScreenToClient(hWnd, &ptTemp);
				SetScrollExtent(hWnd, old_zoom, ptTemp.x + 3);
				if( selecting_range || select_dragging_what )
					SendMessage(hWnd, WM_MOUSEMOVE, 0, MAKELPARAM(ptTemp.x, ptTemp.y));
				RECT rcRedraw = rcWAV;
				rcRedraw.bottom = rcSeq.bottom;
				InvalidateRect(hWnd, &rcRedraw, false);
				UpdateDisabledState(hWnd);
			}
			break;
		}
	case WM_MOUSEMOVE:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			last_mouse_move_lparam = lParam;
			UpdateCursor(hWnd, x, y);
			if( dragging_horz_divider ) {
				int new_divider_pos = min(max(y + divider_drag_pos, rcWAV.top + 32), rcWAV.top + 256);
				if( new_divider_pos != rcWAV.bottom ) {
					rcWAV.bottom = rcSeq.top = new_divider_pos;
					SaveDwordToRegistry(L"horiz_div_pos", new_divider_pos - rcWAV.top);
					RECT rcRedraw = rcWAV;
					rcRedraw.left = 0;
					rcRedraw.bottom = rcSeq.bottom;
					InvalidateRect(hWnd, &rcRedraw, true);
				}
			} else if( dragging_vert_divider ) {
				int new_divider_pos = min(max(x + divider_drag_pos, 32), 256);
				if( new_divider_pos != rcWAV.left ) {
					RECT rcScroll;
					rcScroll.top = rcWAV.top;
					rcScroll.bottom = rcSeq.bottom;
					rcScroll.left = rcWAV.left;
					rcScroll.right = rcWAV.right;
					if( new_divider_pos < rcScroll.left )
						rcScroll.left = new_divider_pos;
					ScrollWindow(hWnd, new_divider_pos - rcWAV.left, 0, &rcScroll, &rcScroll);
					rcWAV.left = new_divider_pos;
					rcSeq.left = new_divider_pos;
					SaveDwordToRegistry(L"vert_div_pos", new_divider_pos);
					rcScroll.right = rcScroll.left;
					rcScroll.left = 0;
					InvalidateRect(hWnd, &rcScroll, true);
				}
			} else if( selecting_range ) {
				if( selecting_drag || abs(x - select_pos) > 4 ) {
					selecting_drag = true;
					si.cbSize = sizeof (si);
					si.fMask  = SIF_ALL;
					GetScrollInfo (hWnd, SB_HORZ, &si);
					SetSelection(hWnd, ((si.nPos + select_pos) - rcWAV.left) << zoom, ((si.nPos + x) - rcWAV.left) << zoom);
				}
			} else if( select_dragging_what ) {
				int start = selection_start, finish = selection_finish;
				if( (select_dragging_what&1) )
					start += (x - select_pos) << zoom;
				if( (select_dragging_what&2) )
					finish += (x - select_pos) << zoom;
				if( start < 0 )
					start = 0;
				else if( start > wav_len )
					start = wav_len;
				if( finish < 0 )
					finish = 0;
				else if( finish > wav_len )
					finish = wav_len;
				if( finish < start ) {
					swap(finish, start);
					if( select_dragging_what != 3 )
						select_dragging_what ^= 3;
				}
				SetSelection(hWnd, start, finish);

				if( select_dragging_what == 2 ) {
					select_pos = x + (selection_finish - finish) / (1<<zoom);
				} else {
					select_pos = x + (selection_start - start) / (1<<zoom);
				}
			} else if( horz_scroll_drag ) {
				if( x != horz_scroll_pos ) {
					HorizScrollWindowBy(hWnd, horz_scroll_pos - x, selecting_range || select_dragging_what);
					horz_scroll_pos = x;
					scroll_follows_playback = 0;
				}
				if( abs(horz_scroll_pos - horz_scroll_init_pos) > 4 )
					horz_scroll_init_pos = -1;
			}
			if( selecting_range || select_dragging_what ) {
				if( x < rcWAV.left || x > rcWAV.right ) {
					SetTimer(hWnd, 1, autoscroll_speed, NULL);
					if( autoscroll_speed > 10 )
						autoscroll_speed -= 10;
				} else {
					KillTimer(hWnd, 1);
					autoscroll_speed = 250;
				}
			}
			if( selecting_lights && NumEnabledLights ) {
				int index = 0;
				for( int i = 0; i < 32; ++i ) {
					if( !(EnabledLights&(1<<i)) )
						continue;
					int bottom = rcSeq.top + (index+1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
					++index;
					if( y < bottom ) {
						if( i != current_light ) {
							int a = i;
							int b = selecting_lights-1;
							if( a > b ) {
								int c = a;
								a = b;
								b = c;
							}
							unsigned long which = (1<<(b+1))-(1<<a);
							SetLightSelection(hWnd, which, i);
						}
						break;
					}
				}
			}
			if( moving_light_selection && NumEnabledLights ) {
				int i, j, index = 0, next_light = -1, prev_light = -1;
				int bottom = moving_light_selection&1;
				for( i = 0; i < (moving_light_selection>>1)-1; ++i ) {
					if( (EnabledLights&(1<<i)) )
						++index;
				}
				for( j = i+1; j < 32; ++j ) {
					if( (EnabledLights&(1<<j)) ) {
						next_light = j;
						break;
					}
				}
				for( j = i-1; j >= 0; --j ) {
					if( (EnabledLights&(1<<j)) ) {
						prev_light = j;
						break;
					}
				}
				int pos = rcSeq.top + (index + bottom) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
				if( !bottom ) {
					if( prev_light != -1 && !(selected_lights&(1<<prev_light)) ) {
						int last_pos = rcSeq.top + (index-1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
						if( y < (pos + last_pos) / 2 ) {
							SetLightSelection(hWnd, selected_lights|(1<<prev_light), current_light);
							moving_light_selection = ((prev_light+1)<<1)|bottom;
						}
					}
					if( next_light != -1 && (selected_lights&(1<<next_light)) ) {
						int next_pos = rcSeq.top + (index+1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
						if( y > (pos + next_pos) / 2 ) {
							SetLightSelection(hWnd, selected_lights&~(1<<i), current_light);
							moving_light_selection = ((next_light+1)<<1)|bottom;
						}
					}
				} else {
					if( prev_light != -1 && (selected_lights&(1<<prev_light)) ) {
						int last_pos = rcSeq.top + index * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
						if( y < (pos + last_pos) / 2 ) {
							SetLightSelection(hWnd, selected_lights&~(1<<i), current_light);
							moving_light_selection = ((prev_light+1)<<1)|bottom;
						}
					}
					if( next_light != -1 && !(selected_lights&(1<<next_light)) ) {
						int next_pos = rcSeq.top + (index+2) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
						if( y > (pos + next_pos) / 2 ) {
							SetLightSelection(hWnd, selected_lights|(1<<next_light), current_light);
							moving_light_selection = ((next_light+1)<<1)|bottom;
						}
					}
				}
			}
			break;
		}
	case WM_TIMER:
		if( wParam == 1 ) {
			POINT ptCursor;
			GetCursorPos(&ptCursor);
			ScreenToClient(hWnd, &ptCursor);
			if( ptCursor.x < rcWAV.left || ptCursor.x > rcWAV.right ) {
				HorizScrollWindowBy(hWnd, ptCursor.x > rcWAV.right ? 10 : -10, selecting_range || select_dragging_what);
				scroll_follows_playback = 0;
				WndProc(hWnd, WM_MOUSEMOVE, 0, MAKELPARAM(ptCursor.x, ptCursor.y));
			}
		} else if( wParam == 2 ) {
			int samples = playback_get_current_sample();
			MovePlaybackPos(hWnd, samples);

			si.cbSize = sizeof (si);
			si.fMask  = SIF_ALL;
			GetScrollInfo (hWnd, SB_HORZ, &si);
			int playback_x = rcWAV.left + (playback_pos >> zoom) - (int)si.nPos;
			if( !scroll_follows_playback && follow_playback_pos ) {
				if( g_bPlayingView ) {
					if( playback_x < rcWAV.left || playback_x > rcWAV.right ) {
						scroll_follows_playback = 1;
						scroll_original_pos = si.nPos;
					}
				} else {
					if( (playback_x < (rcWAV.left * 3 + rcWAV.right) / 4 && si.nPos > 0) ||
						playback_x > (rcWAV.left + rcWAV.right * 3) / 4 && si.nPos < (wav_len>>zoom) - (int)(si.nPage-1) ) {
						scroll_follows_playback = 1;
						scroll_original_pos = si.nPos;
					}
				}
			}
			if( scroll_follows_playback ) {
				int diff = samples == -1 || !follow_playback_pos ? (scroll_original_pos - (int)si.nPos) : (playback_x - (rcWAV.left + rcWAV.right) / 2);

				if( (int)si.nPos + diff < 0 )
					diff = -(int)si.nPos;
				if( (int)si.nPos + diff > (int)si.nMax - ((int)si.nPage - 1) )
					diff = si.nMax - (si.nPage - 1) - si.nPos;

				int max = 16;
				if( zoom < 8 )
					max <<= (8 - zoom);
				
				if( diff > max )
					diff = max;
				else if( diff < -max )
					diff = -max;

				HorizScrollWindowBy(hWnd, diff, selecting_range || select_dragging_what);
				if( diff == 0 && samples == -1 )
					scroll_follows_playback = 0;
			}

			InvalidateLightBarLights(hWnd, samples);
			InvalidateStatus(hWnd);

			if( samples == -1 ) {
				DelayedUpdateDisabledState(hWnd);
				KillTimer(hWnd, 2);
			}
		} else if( wParam == 3 ) {
			UpdatePublishEnabledStatus(hWnd);
		} else if( wParam == 4 ) {
			KillTimer(hWnd, 4);
			if( hDialog )
				SendMessage(hDialog, WM_MAINSCROLL, 0, 0);
		}
		break;
	case WM_LBUTTONDOWN:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			UpdateCursor(hWnd, x, y);

			if( (x < rcWAV.left - 4 || ((wParam&(MK_SHIFT|MK_CONTROL)) && y > rcWAV.bottom + 4 && y < rcSeq.bottom)) && NumEnabledLights ) {
				int i, index = 0;
				for( i = 0; i < 32; ++i ) {
					if( !(EnabledLights&(1<<i)) )
						continue;
					int top    = rcSeq.top +  index    * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
					int bottom = rcSeq.top + (index+1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
					++index;
					if( y >= top && y < bottom )
						break;
				}
				if( i < 32 ) {
					unsigned long which;
					if( wParam & MK_SHIFT ) {
						int a = i;
						int b = current_light;
						if( wParam & MK_CONTROL ) {
							if( a > b )
								++b;
							else if( a < b )
								--b;
						}
						if( a > b ) {
							int c = a;
							a = b;
							b = c;
						}
						which = (1<<(b+1))-(1<<a);
					} else {
						which = 1<<i;
					}
					SetLightSelection(hWnd, (wParam&MK_CONTROL) ? (selected_lights^which) : which, i);
				}
			} else if( x >= rcWAV.left - 4 && x <= rcWAV.left + 4 ) {
				dragging_vert_divider = 1;
				divider_drag_pos = rcWAV.left - x;
			} else if( y >= rcWAV.top && y < rcWAV.bottom - 4 ) {
			CheckMoveSelection:
				if( hDialog && !CanChangeSelection(hDialog) ) {
					MessageBox(hWnd, L"You can not change the selection while a dialog is open. Please close it first.", L"Can't make changes with dialog open", MB_OK|MB_ICONEXCLAMATION);
					SetForegroundWindow(hDialog);
					break;
				}
				si.cbSize = sizeof (si);
				si.fMask  = SIF_ALL;
				GetScrollInfo (hWnd, SB_HORZ, &si);
				int select_x1 = (selection_start >> zoom) - si.nPos + rcWAV.left;
				int select_x2 = (selection_finish >> zoom) - si.nPos + rcWAV.left;
				if( (x >= select_x1-4 && x <= select_x1+4) || (x >= select_x2-4 && x <= select_x2+4) ) {
					select_dragging_what = selection_start == selection_finish ? 3 : (x >= select_x1-4 && x <= select_x1+4) ? 1 : 2;
				} else {
					selecting_range = true;
					selecting_drag = false;
					if( maybe_selecting_lights ) {
						SetLightSelection(hWnd, 1<<(maybe_selecting_lights-1), maybe_selecting_lights-1);
						selecting_lights = maybe_selecting_lights;
					}
				}
				maybe_selecting_lights = 0;
				autoscroll_speed = 250;
				select_pos = x;
				SetCapture(hWnd);
			} else if( y > rcWAV.bottom - 4 && y < rcSeq.bottom && NumEnabledLights ) {
				si.cbSize = sizeof (si);
				si.fMask  = SIF_ALL;
				GetScrollInfo (hWnd, SB_HORZ, &si);
				int select_x1 = rcWAV.left + (selection_start >> zoom) - si.nPos;
				int select_x2 = rcWAV.left + (selection_finish >> zoom) - si.nPos;

				bool bLastSel = false;
				int index = 0;
				for( int i = 0; i < 32; ++i ) {
					if( !(EnabledLights&(1<<i)) )
						continue;
					int top    = rcSeq.top +  index    * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
					int bottom = rcSeq.top + (index+1) * (rcSeq.bottom - rcSeq.top - 1) / NumEnabledLights;
					++index;
					bool bThisSel = (selected_lights&(1<<i)) != 0;
					bool bNextSel = i < 31 && (selected_lights&(1<<(i+1))) != 0;
					if( x >= select_x1 && x <= select_x2 && bThisSel && !bLastSel && y >= top-4 && y <= top+4 ) {
						if( hDialog && !CanChangeSelection(hDialog) ) {
							MessageBox(hWnd, L"You can not change the selection while a dialog is open. Please close it first.", L"Can't make changes with dialog open", MB_OK|MB_ICONEXCLAMATION);
							break;
						}
						moving_light_selection = (i+1)*2;
						SetCapture(hWnd);
						break;
					}
					if( x >= select_x1 && x <= select_x2 && bThisSel && !bNextSel && y >= bottom-4 && y <= bottom+4 ) {
						if( hDialog && !CanChangeSelection(hDialog) ) {
							MessageBox(hWnd, L"You can not change the selection while a dialog is open. Please close it first.", L"Can't make changes with dialog open", MB_OK|MB_ICONEXCLAMATION);
							break;
						}
						moving_light_selection = (i+1)*2+1;
						SetCapture(hWnd);
						break;
					}
					bLastSel = bThisSel;
					if( y < bottom ) {
						if( (selected_lights&(1<<i)) && x >= select_x1-4 && x <= select_x2+4 ) {
							maybe_selecting_lights = i+1;
							goto CheckMoveSelection;
						} else if( !(bNextSel && !bThisSel && y >= bottom-4) ) {
							if( hDialog && !CanChangeSelection(hDialog) ) {
								MessageBox(hWnd, L"You can not change the selection while a dialog is open. Please close it first.", L"Can't make changes with dialog open", MB_OK|MB_ICONEXCLAMATION);
								break;
							}
							SetSelection(hWnd, -1, -1);
							SetLightSelection(hWnd, 1<<i, i);
							selecting_lights = i+1;
							selecting_range = true;
							selecting_drag = false;
							autoscroll_speed = 250;
							select_pos = x;
							SetCapture(hWnd);
							break;
//							goto CheckMoveSelection;
						}
					}
				}
				if( y <= rcWAV.bottom + 4 ) {
					dragging_horz_divider = 1;
					divider_drag_pos = rcWAV.bottom - y;
					SetCapture(hWnd);
				}
			}
			break;
		}
	case WM_LBUTTONUP:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			UpdateCursor(hWnd, x, y);

			if( selecting_range || select_dragging_what || dragging_horz_divider || moving_light_selection )
				ReleaseCapture();
			if( selecting_range && !selecting_drag ) {
				si.cbSize = sizeof (si);
				si.fMask  = SIF_ALL;
				GetScrollInfo (hWnd, SB_HORZ, &si);
				int pos = ((si.nPos + select_pos) - rcWAV.left) << zoom;
				SetSelection(hWnd, pos, pos);
			}
			dragging_horz_divider = 0;
			dragging_vert_divider = 0;
			selecting_range = 0;
			select_dragging_what = 0;
			selecting_lights = 0;
			moving_light_selection = 0;
			KillTimer(hWnd, 1);
			break;
		}
	case WM_RBUTTONDOWN:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			UpdateCursor(hWnd, x, y);

			horz_scroll_drag = 1;
			horz_scroll_pos = horz_scroll_init_pos = x;
			SetCapture(hWnd);
			break;
		}
	case WM_RBUTTONUP:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			UpdateCursor(hWnd, x, y);

			horz_scroll_drag = 0;
			if( horz_scroll_init_pos != -1 ) {
				int scroll = horz_scroll_init_pos - rcWAV.left - (rcWAV.left + rcWAV.right) / 2;
				if( scroll ) {
					HorizScrollWindowBy(hWnd, scroll, selecting_range || select_dragging_what);
					scroll_follows_playback = 0;
				}
			}
			ReleaseCapture();
			break;
		}
	case WM_MBUTTONDOWN:
	case WM_MBUTTONUP:
		{
			int x = GET_X_LPARAM(lParam), y = GET_Y_LPARAM(lParam);
			UpdateCursor(hWnd, x, y);
			break;
		}
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);
		DrawWAV(hWnd, hdc);
		DrawSequences(hWnd, hdc, light_names, light_colours, true);
		DrawLightbar(hWnd, hdc, light_colours);
		DrawStatus(hWnd, hdc);
		EndPaint(hWnd, &ps);
		break;
	case WM_ERASEBKGND:
		break;
	case WM_NOTIFY:
		{
			LPNMHDR pnmh = (LPNMHDR)lParam;
			LPTOOLTIPTEXT lpttt;
			ToolbarEntry* pEntry;
			if( pnmh->hwndFrom == hToolbar || pnmh->code == TTN_NEEDTEXT ) {
				switch(pnmh->code) {
				case TTN_NEEDTEXT:
					lpttt = (LPTOOLTIPTEXT)lParam;
					pEntry = FindToolbarEntry((DWORD)lpttt->hdr.idFrom, false);
					if( pEntry ) {
						const wchar_t* reason;
						bool bEnabled = pEntry->CheckEnabled ? pEntry->CheckEnabled(&reason) : true;
						lpttt->hinst = hInst;
						if( bEnabled ) {
							lpttt->lpszText = pEntry->tooltip;
						} else {
							static wchar_t text_buf[1024];
							wsprintf(text_buf, L"%s (%s)", pEntry->tooltip, reason);
							lpttt->lpszText = text_buf;
						}
					}
					break;
				case TBN_DROPDOWN:
					{
						LPNMTOOLBAR pToolBar = reinterpret_cast<LPNMTOOLBAR>(pnmh);
						if( pToolBar->iItem == IDM_SETBRIGHT ) {
							POINT ptToolbar = { pToolBar->rcButton.right, pToolBar->rcButton.bottom };
							RECT rcDropdown;
							ClientToScreen(hWnd, &ptToolbar);
							hDropdown = CreateDialog(hInst, MAKEINTRESOURCE(IDD_BRIGHTNESSDROPDOWN), hWnd, &BrightnessDropdownDialogProc);
							GetWindowRect(hDropdown, &rcDropdown);
							SetWindowPos(hDropdown, HWND_TOPMOST, ptToolbar.x - (rcDropdown.right-rcDropdown.left), ptToolbar.y, 0, 0, SWP_NOSIZE);
							ShowWindow(hDropdown, TRUE);
						} else if( pToolBar->iItem == IDM_CASCADE || pToolBar->iItem == IDM_CUSTOM_RAMP || pToolBar->iItem == IDM_BEATDETECTION || pToolBar->iItem == IDM_SPECTRUMANALYSIS ) {
							SendMessage(hWnd, WM_COMMAND, pToolBar->iItem, 0);
						}
						break;
					}
				}
			}
		}
		break;
	case WM_USER:
		UpdateDisabledState(hWnd);
		break;
	case WM_CLOSE:
		CloseSequence(hWnd);
		if( !sequence_loaded )
			return DefWindowProc(hWnd, message, wParam, lParam);
		break;
	case WM_DESTROY:
		if( hDialog )
			DestroyWindow(hDialog);
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}
